import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'presentation',
        'admin',
        'content_type',
        'slug',
        {
          blocks: {
            fields: [
              'uuid',
              'title',
              'background_color',
              'dark_mode',
              'icon',
              'image',
              'link',
              'admin',
              'content_type',
              'link_label',
              'open_in_new_tab'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          cards_links: {
            fields: ['uuid', 'title', 'image', 'link', 'content_type', 'admin'],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'email',
              'function',
              'phone'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          spaces_pages_categories: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacesPagesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'banner',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

