import { withFetch } from 'inside-collection/hocs'

import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import {
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces/spaces'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false, content: 'events' }
  },
  {
    name: 'NewsCategoriesListingPage',
    meta: { disabled: false, content: 'news_categories_listings' }
  },
  {
    name: 'NewsCategoriesPage',
    meta: { disabled: false, content: 'news_categories_listings,news' }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false, content: 'news' }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage),
    meta: { content: 'spaces' }
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/pages/:slug',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(
      fetchSpacesPagesPage
    ),
    meta: { content: 'spaces' }
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false, content: 'tabs_spaces' }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'FormPage',
    meta: { disabled: true, content: 'forms' }
  },
  {
    name: 'AdminAdvancedSettingsAutomaticTranslationPage',
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsSsoConnectionPage',
    meta: { admin: true, display: true }
  }
]
