<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateContentTypesTitles extends Migration
{
    public function up(): void
    {
        $types = [
            "spaces" => "Mon espace",
            "pages" => "Page",
            "spaces_pages" => "Infos pratiques",
            "spaces_pages_categories" => "Catégorie d'infos pratiques",
            "tabs_pages" => "L'institut",
            "users" => "Membre",
        ];

        $bridgeContentType = new BridgeContentType();
        collect($types)->each(function ($title, $type) use ($bridgeContentType) {
            $bridgeContentType->contentTypeUpdateOrCreate($type, [
                'name' => $type,
                'title' => [
                    'fr' => $title,
                ],
            ]);
        });

        $bridgeContentType->contentTypeUpdateOrCreate("faq_categories", [
            "name" => "faq_categories",
            "global_searchable" => false,
        ]);
    }
}
