<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\ToolsCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;

class TranslateDefaultToolsForLiry extends Migration
{
    public function up(): void
    {
        $defaultTools = [
            'Webmel' => 0,
            'Annuaire' => 1,
            'Assistance informatique' => 2,
            'Réservation de salles' => 3,
            'Communiquer sur MyLiryc' => 4,
            'Site institutionnel' => 5,
        ];

        $allTools = Tools::query()
            ->whereIn('title', array_keys($defaultTools))
            ->get()
            ->sortBy(fn ($tool) => $defaultTools[$tool->title]);

        $defaultToolsUuids = $allTools->map(
            fn ($tool) => ['target_uuid' => $tool->uuid_host]
        )->toArray();

        $bridge = new BridgeContent();
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'fr' => 'Accès rapide',
                    'en' => 'Quick access'
                ],
                'default' => $defaultToolsUuids
            ]
        );

        Users::all()->each(fn ($user) => $bridge->updateReferenceFields(
            type: 'users',
            contentUuidHost: $user->uuid_host,
            data: [
                'tools' => $defaultToolsUuids
            ]
        ));
    }
}
