<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Models\Contents\MovementsCategories;

class LiryTranslateMovements extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('movements_categories');
        $this->migrateContent('movements');

        Artisan::call("models:rebuild");

        $categories = [
            [
                'template' => 'arrival',
                'title' => [
                    'fr' => 'Arrivée',
                    'en' => 'Arrival',
                    'es' => 'Incorporación',
                    'de' => 'Eintritt',
                    'pt' => 'Chegada',
                    'nl' => 'Aankomst',
                ],
                'button_text' => [
                    'fr' => 'Bienvenue',
                    'en' => 'Welcome',
                    'es' => 'Bienvenido',
                    'de' => 'Willkommen',
                    'pt' => 'Bem-vindo',
                    'nl' => 'Welkom',
                ],
            ],
            [
                'template' => 'nomination',
                'title' => [
                    'fr' => 'Nomination',
                    'en' => 'Nomination',
                    'es' => 'Nominación',
                    'de' => 'Nominierung',
                    'pt' => 'Nomeação',
                    'nl' => 'Benoeming',
                ],
                'button_text' => [
                    'fr' => 'Félicitations',
                    'en' => 'Congratulations',
                    'es' => 'Felicidades',
                    'de' => 'Glückwunsch',
                    'pt' => 'Parabéns',
                    'nl' => 'Gefeliciteerd',
                ],
            ],
        ];

        $bridge = new BridgeContent();
        foreach ($categories as $category) {
            foreach (list_languages() as $langcode) {
                $uuid = MovementsCategories::where(['template' => $category['template'], 'langcode' => $langcode])->first()?->uuid;

                if (! $uuid) {
                    continue;
                }

                $data = collect($category)
                    ->map(function ($item) use ($langcode) {
                        if (! is_array($item)) {
                            return $item;
                        }

                        return $item[$langcode] ?? $item['en'];
                    })
                    ->all();

                $data['uuid'] = $uuid;

                $bridge->contentUpdate('movements_categories', $data);
            }
        }

        $this->finishUp();
    }
}
