<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class LiryShowLanguageFieldsMultilangue extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        foreach (Schema::getContentTypes() as $type) {
            $options = Schema::getModelOptions($type);
            if (Schema::hasField($type, 'langcode') && !in_array(
                $type,
                ['users', 'comments', 'footer_menus', 'main_menus', 'shortcuts_menus']
            )) {
                try {
                    $bridge->updateContentTypeOptions(
                        type: $type,
                        options: [
                            'translatable' => true,
                        ]
                    );
                    $bridge->changeFieldFormOptions($type, 'langcode', true, 'group_advanced_options');
                } catch (\Exception $e) {
                    dump($type, $e->getMessage());
                }
            }
        }
    }
}
