<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditPhonesFieldsForLiry extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            entityType: 'user',
            type: 'user',
            fieldName: 'phone',
        );

        $bridge->contentTypeDeleteField(
            entityType: 'user',
            type: 'user',
            fieldName: 'mobile_phone',
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'phone',
            options:  [
                'name' => 'phone',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Téléphone fixe',
                    'en' => 'Office Phone',
                    'nl' => 'Telefoon',
                    'pt' => 'Telefone',
                    'es' => 'Teléfono',
                    'de' => 'Telefon',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ]
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'mobile_phone',
            options:  [
                'name' => 'mobile_phone',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Téléphone mobile',
                    'en' => 'Mobile Phone',
                    'nl' => 'Mobiele telefoon',
                    'pt' => 'Telefone móvel',
                    'es' => 'Teléfono móvil',
                    'de' => 'Handy',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ]
            ]
        );
    }
}
