<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddProjectFieldToUsers extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bridge = new BridgeContentType();
        $this->bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'project',
            options: [
                'name' => 'project',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Projet',
                    'en' => 'Project',
                    'es' => 'Proyecto',
                    'de' => 'Projekt',
                    'pt' => 'Projeto',
                    'nl' => 'Project',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 5,
                    'group' => 'group_infos',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 12
        );
    }
}
