<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateUsersFieldsForLiry extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateInitialContent();
        $this->call('models:rebuild');

        $this->bridge = new BridgeContentType();

        $this->createReferenceFields();
        $this->createLocationField();
        $this->createPhoneFields();
        $this->createLinkField();

        $this->call('models:rebuild');
        $this->finishUp();
    }

    private function migrateInitialContent(): void
    {
        $this->migrateContent('poles', false);
        $this->migrateContent('teams', false);
        $this->migrateContent('preferred_language', false);
    }

    private function createReferenceFields(): void
    {
        $fields = collect([
            'poles' => 'Pôle',
            'teams' => 'Équipe',
            'preferred_language' => 'Langue préférée',
        ]);

        $fields->each(function ($title, $field) {
            $this->bridge->contentTypeCreateOrUpdateField(
                type: 'users',
                fieldName: $field,
                options: [
                    'name' => $field,
                    'searchable' => true,
                    'translatable' => true,
                    'search_result_field' => true,
                    'searchable_filter' => true,
                    'required' => false,
                    'weight' => 12,
                    'title' => [
                        'fr' => $title,
                    ],
                    'widget' => [
                        'type' => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                        'weight' => 1,
                        'group' => 'group_infos',
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => [$field],
                        'cardinality' => 1,
                    ],
                    'selectable_all' => true,
                ],
                weight: 12
            );
        });
    }

    private function createPhoneFields(): void
    {
        $mobileFields = collect([
            'phone' => 'Téléphone fixe',
            'mobile_phone' => 'Téléphone mobile',
        ]);

        $mobileFields->each(function ($title, $field) {
            $this->bridge->contentTypeCreateOrUpdateField(
                type: 'users',
                fieldName: $field,
                options: [
                    'name' => $field,
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 13,
                    'title' => [
                        'fr' => $title,
                    ],
                    'widget' => [
                        'type' => BridgeContentType::INSIDE_PHONE_WIDGET,
                        'weight' => 1,
                        'group' => 'group_infos',
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ],
                weight: 13
            );
        });
    }

    private function createLinkField(): void
    {
        $this->bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'link',
            options: [
                'name' => 'link',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 14,
                'title' => [
                    'fr' => 'Lien URL',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                    'group' => 'group_infos',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 14
        );
    }

    private function createLocationField(): void
    {
        $this->bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'location',
            options: [
                'name' => 'location',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Localisation',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                    'group' => 'group_infos',
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 12
        );
    }
}
