<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'spaces',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Espace widget',
            'en' => 'Widget space',
            'nl' => 'Widget ruimte',
            'pt' => 'Espaço de widget',
            'es' => 'Espacio de widget',
            'de' => 'Widget-Raum',
        ],
    ],
    'fields' => [
        [
            'name' => 'banner',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'nl' => 'Banner',
                'pt' => 'Banner',
                'es' => 'Banner',
                'de' => 'Banner',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
                'nl' => 'Introductie',
                'pt' => 'Introdução',
                'es' => 'Introducción',
                'de' => 'Einleitung',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'presentation',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Présentation',
                'en' => 'Presentation',
                'nl' => 'Presentatie',
                'pt' => 'Apresentação',
                'es' => 'Presentación',
                'de' => 'Präsentation',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'users',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Contacts clés',
                'en' => 'Key contacts',
                'nl' => 'Belangrijke contacten',
                'pt' => 'Contatos chave',
                'es' => 'Contactos clave',
                'de' => 'Schlüsselkontakte',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'blocks',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Bloc',
                'en' => 'Block',
                'nl' => 'Blok',
                'pt' => 'Bloco',
                'es' => 'Bloque',
                'de' => 'Block',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['blocks'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'cards_links',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Image avec lien',
                'en' => 'Image with link',
                'nl' => 'Afbeelding met link',
                'pt' => 'Imagem com link',
                'es' => 'Imagen con enlace',
                'de' => 'Bild mit Link',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['cards_links'],
                'cardinality' => 1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'news_categories',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Catégorie(s) d\'actualité',
                'en' => 'News category(ies)',
                'nl' => 'Nieuws categorie(ën)',
                'pt' => 'Categoria(s) de notícias',
                'es' => 'Categoría(s) de noticias',
                'de' => 'Nachrichtenkategorie(n)',
            ],
            'description' => [
                'fr' => 'Choix de la (ou des) catégorie(s) d\'actualité à afficher dans l\'espace',
                'en' => 'Select the news category(ies) to display in the space',
                'nl' => 'Selecteer de nieuws categorie(ën) die in de ruimte moeten worden weergegeven',
                'pt' => 'Selecione a(s) categoria(s) de notícias a serem exibidas no espaço',
                'es' => 'Seleccione la(s) categoría(s) de noticias que se mostrarán en el espacio',
                'de' => 'Wählen Sie die Nachrichtenkategorie(n), die im Raum angezeigt werden sollen',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
    ],
];
