<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'name' => 'Newsletter',
    ],
    'logo' => [
        'showLogo' => true,
        'logoWidth' => 80,
    ],
    'banner' => [
        'backgroundColor' => '#ffff',
        'height',
    ],
    'introduction' => [
        'introductionFieldName' => 'introduction',
    ],
    'sections' => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'defaultCategoryColor' => '#1E6277',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#203169',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1E6277',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#203169',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#203169'
            ],
        ],
        'new_members' => [
            'types' => ['movements'],
            'leftLineColor' => '#D6002A',
            'link' => [
                'sectionLinkUrl' => 'movements',
                'sectionTextColor' => '#D6002A',
            ],
        ],
        'activities' => [
            'link'        => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#2c3f50',
            'items'       => [
                'comments' => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Comments::count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/liry-back/resources/assets/img/newsletter/comment.png',
                    'titleStrKey'        => 'newsletter.comments_statistic',
                ],
                'likes'    => [
                    'callback'           => function () {
                        return \Inside\Reaction\Models\Reaction::where('type',
                            'like')->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/liry-back/resources/assets/img/newsletter/like.png',
                    'titleStrKey'        => 'newsletter.likes_statistic',
                ],
                'users'    => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Users::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/liry-back/resources/assets/img/newsletter/directory.png',
                    'titleStrKey'        => 'newsletter.users_statistic',
                ],
                'news'     => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\News::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/liry-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey'        => 'newsletter.contents_statistic',
                ],
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#1E6277',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/ihuliryc',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/ihu-liryc',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/@ihuliryc2629',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/ihu.liryc/',
            ]
        ],
    ],
];
