<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;

class FixTranslationsIssues extends Migration
{
    public function up(): void
    {
        $types = [
            'spaces_pages_categories' => [
                'fr' => 'Regroupement de page widget',
                'en' => 'Categories of practical information',
            ],
            'spaces_pages' => [
                'fr' => 'Page widget',
                'en' => 'Practical information',
            ],
            'tabs_pages' => [
                'fr' => 'Sous Page Onglet',
                'en' => 'Institute',
            ],
            'spaces' => [
                'fr' => 'Espace widget',
                'en' => 'My space',
            ],
            'pages' => [
                'fr' => 'Page simple',
                'en' => 'Page',
            ],
            'faq_questions' => [
                'fr' => 'Question FAQ',
                'en' => 'FAQ question',
            ],
            'teams' => [
                'fr' => 'Équipe',
                'en' => 'Team',
            ]
        ];

        $fields = [
            'users' => [
                'phone' => [
                    'fr' => 'Téléphone',
                    'en' => 'Phone',
                ],
                'poles' => [
                    'fr' => 'Pôles',
                    'en' => 'Poles'
                ],
                'project' => [
                    'fr' => 'Projet',
                    'en' => 'Project',
                ],
                'location' => [
                    'fr' => 'Localisation',
                    'en' => 'Localization',
                ],
                'link' => [
                    'fr' => 'Lien',
                    'en' => 'Link',
                ],
                'preferred_language' => [
                    'fr' => 'Langue préférée',
                    'en' => 'Preferred language',
                ],
                'mobile_phone' => [
                    'fr' => 'Téléphone mobile',
                    'en' => 'Mobile Phone',
                ],
                'teams' => [
                    'fr' => 'Équipe',
                    'en' => 'Team',
                ]
            ],
            'postings' => [
                'image' => [
                    'fr' => 'Image',
                    'en' => 'Picture',
                ],
                'summary' => [
                    'fr' => 'Résumé',
                    'en' => 'Summary',
                ],
                'postings_location' => [
                    'fr' => 'Localisation',
                    'en' => 'Location',
                ],
                'postings_categories' => [
                    'fr' => 'Catégorie d\'annonces',
                    'en' => 'Ads category',
                ],
                'contact' => [
                    'fr' => 'Email de contact',
                    'en' => 'Contact email',
                ],
                'content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                ]
            ],
            'media_viewer' => [
                'chapo' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                ],
                'content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                ],
            ],
            'spaces_pages_categories' => [
                'icon' => [
                    'fr' => 'Icone',
                    'en' => 'Icon',
                ],
                'icon_color' => [
                    'fr' => 'Couleur de l\'icône',
                    'en' => 'Icon color',
                ],
                'image' => [
                    'fr' => 'Image',
                    'en' => 'Image',
                ],
                'spaces' => [
                    'fr' => 'Espace',
                    'en' => 'Space',
                ],
                'weight' => [
                    'fr' => 'Ordre d\'affichage',
                    'en' => 'Display order',
                ]
            ],
            'connexion_popups' => [
                'content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                ],
                'end_date' => [
                    'fr' => 'Date de fin',
                    'en' => 'End date',
                ]
            ],
            'pages' => [
                'banner' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                ],
                'chapo' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                ],
                'color' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                ],
                'content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                ]
            ],
            'spaces_pages' => [
                'spaces_pages_categories' => [
                    'fr' => 'Regroupement de page',
                    'en' => 'Page grouping',
                ],
                'weight' => [
                    'fr' => 'Ordre d\'affichage',
                    'en' => 'Display order',
                ],
                'content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                ]
            ],
            'public_pages' => [
                'content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                ]
            ],
            'tools_categories_listings' => [
                'color' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                ]
            ],
            'popins' => [
                'content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                ]
            ],
            'postings_categories' => [
                'color' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                ]
            ],
            'custom' => [
                'introduction' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                ],
                'color' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                ]
            ],
            'movements_categories' => [
                'color' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                ],
                'template' => [
                    'fr' => 'Modèle',
                    'en' => 'Template',
                ]
            ],
            'spaces' => [
                'banner' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                ],
                'introduction' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                ],
                'presentation' => [
                    'fr' => 'Présentation',
                    'en' => 'Presentation',
                ],
                'users' => [
                    'fr' => 'Contacts clés',
                    'en' => 'Key contacts',
                ],
                'blocks' => [
                    'fr' => 'Bloc',
                    'en' => 'Block',
                ],
                'cards_links' => [
                    'fr' => 'Image avec lien',
                    'en' => 'Image with link',
                ],
                'news_categories' => [
                    'fr' => 'Catégorie(s) d\'actualité',
                    'en' => 'News category(ies)',
                ]
            ],
            'news_categories_listings' => [
                'introduction' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                ],
                'banner' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                ],
                'color' => [
                    'fr' => 'Couleur du titre et de l’introduction',
                    'en' => 'Title and introduction color',
                ],
                'filter_format' => [
                    'fr' => 'Format du filtre',
                    'en' => 'Filter format',
                ],
                'news_view_mode' => [
                    'fr' => 'Affichage des news',
                    'en' => 'News display',
                ],
                'add_search_bar' => [
                    'fr' => 'Ajouter une barre de recherche',
                    'en' => 'Add a search bar',
                ],

            ],
            'news_categories' => [
                'news_categories_listings' => [
                    'fr' => 'Listing catégorie d\'actualités',
                    'en' => 'News categories listing',
                ]
            ],
            'tabs_spaces' => [
                'color' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                ]
            ]
        ];

        foreach ($types as $type => $translations) {
            InsideSchema::setModelOption($type, 'title', $translations);
        }

        foreach ($fields as $contentType => $field) {
            foreach ($field as $fieldName => $translations) {
                InsideSchema::updateFieldOption($contentType, $fieldName, 'title', $translations);
            }
        }
    }
}
