<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class LiryTranslateUntranslatedTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('teams');
        Artisan::call("models:rebuild");
        $this->finishUp();

        $bridge = new BridgeContentType();
        $bridge->updateContentTypeOptions(
            type: 'users',
            options: [
                'name' => 'users',
                'translatable' => false,
                'title' => [
                    'fr' => 'Utilisateur',
                    'en' => 'User',
                    'nl' => 'Gebruiker',
                    'pt' => 'Utilizador',
                    'es' => 'Espace métier',
                    'de' => 'Benutzer',
                ],
            ]
        );

        collect([
            'popins' => [
                'fr' => 'Consentement utilisateur',
                'en' => 'User Consent',
                'es' => 'Consentimiento del usuario',
                'de' => 'Nutzerzustimmung',
                'pt' => 'Consentimento do usuário',
                'nl' => 'Toestemming van de gebruiker',
            ],
            'postings' => [
                'fr' => 'Petite annonce',
                'en' => 'Ads',
                'de' => 'Kleinanzeige',
                'nl' => 'Advertentie',
                'es' => 'Anuncio',
                'pt' => 'Anúncio',
            ],
            'postings_categories' => [
                'fr' => 'Catégorie de petite annonce',
                'en' => 'Ads category',
                'de' => 'Kategorie der Kleinanzeige',
                'nl' => 'Categorie van kleine advertenties',
                'es' => 'Categoría de anuncio clasificado',
                'pt' => 'Categoria de anúncio classificado',
            ],
            'preferred_language' => [
                'fr' => 'Langue préférée',
                'en' => 'Preferred language',
                'de' => 'Bevorzugte Sprache',
                'nl' => 'Voorkeurstaal',
                'es' => 'Idioma preferido',
                'pt' => 'Idioma preferido',
            ],
            'poles' => [
                'fr' => 'Pôle d\'activité',
                'en' => 'Hub',
                'nl' => 'Activiteitencentrum',
                'pt' => 'Pólo de atividade',
                'es' => 'Polo de actividad',
                'de' => 'Geschäftsbereich',
            ],
            'media_viewer' => [
                'fr' => 'Carrousel',
                'en' => 'Carousel',
                'es' => 'Carrusel',
                'pt' => 'Carrossel',
                'de' => 'Karussell',
                'nl' => 'Carrousel',
            ],
            'news_categories_listings' => [
                'fr' => 'Listing catégorie d\'actualités',
                'en' => 'News categories listing',
                'es' => 'Listado de categorías de noticias',
                'pt' => 'Listagem de categorias de notícias',
                'de' => 'Nachrichtenkategorienliste',
                'nl' => 'Lijst van nieuwscategorieën',
            ],
            'spaces' => [
                'fr' => 'Espace widget',
                'en' => 'Widget space',
                'nl' => 'Widget ruimte',
                'pt' => 'Espaço de widget',
                'es' => 'Espacio de widget',
                'de' => 'Widget-Raum',
            ],
            'spaces_pages' => [
                'fr' => 'Page widget',
                'en' => 'Widget page',
                'nl' => 'Widget pagina',
                'pt' => 'Página de widget',
                'es' => 'Página de widget',
                'de' => 'Widget-Seite',
            ],
            'spaces_pages_categories' => [
                'fr' => 'Regroupement de page widget',
                'en' => 'Widget page grouping',
                'nl' => 'Widget pagina groepering',
                'pt' => 'Agrupamento de página de widget',
                'es' => 'Agrupación de página de widget',
                'de' => 'Widget-Seitengruppierung',
            ],
            'teams' => [
                'fr' => 'Équipe',
                'en' => 'Team',
                'nl' => 'Team',
                'pt' => 'Time',
                'es' => 'Equipo',
                'de' => 'Team',
            ],
            "connexion_popups" => [
                "nl" => "Inlogvenster",
                "de" => "Login-Popup",
                "es" => "Ventana emergente de inicio de sesión",
                "fr" => "Popin de connexion",
                "en" => "Login popup",
                "pt" => "Janela de login",
            ],
            "dms_link" => [
                "nl" => "Link",
                "de" => "Link",
                "es" => "Enlace",
                "fr" => "Lien",
                "en" => "Link",
                "pt" => "Link",
            ],
            "movements" => [
                "nl" => "Bewegingen",
                "de" => "Bewegungen",
                "es" => "Movimientos",
                "fr" => "Mouvements",
                "en" => "Movements",
                "pt" => "Movimentos",
            ],
            "movements_categories" => [
                "nl" => "Categorie beweging",
                "de" => "Bewegungskategorie",
                "es" => "Categoría de movimiento",
                "fr" => "Catégorie de mouvement",
                "en" => "Movement category",
                "pt" => "Categoria de movimento",
            ],
            "pages" => [
                "nl" => "Enkele pagina",
                "de" => "Einzelne Seite",
                "es" => "Una sola página",
                "fr" => "Page simple",
                "en" => "Single page",
                "pt" => "Página única",
            ],
            "public_pages" => [
                "nl" => "Openbare pagina",
                "de" => "Öffentliche Seite",
                "es" => "Pagina publica",
                "fr" => "Page publique",
                "en" => "Public page",
                "pt" => "Página pública",
            ],
            "top_footer" => [
                "nl" => "Op voettekst",
                "de" => "In der Fußzeile",
                "es" => "En pie de página",
                "fr" => "Sur footer",
                "en" => "On footer",
                "pt" => "No rodapé",
            ],
        ])->each(function ($titles, $type) use ($bridge) {
            $bridge->contentTypeUpdateOrCreate(
                type: $type,
                options: [
                    'name' => $type,
                    'title' => $titles,
                    'translatable' => true,
                ]
            );
            $bridge->updateContentTypeOptions(
                type: $type,
                options: [
                    'name' => $type,
                    'title' => $titles,
                    'translatable' => true,
                ]
            );
            $bridge->changeFieldFormOptions($type, 'langcode', true, 'group_advanced_options');
        });
    }
}
