<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeUserUntranslatable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->updateContentTypeOptions(
            type: 'users',
            options: [
                'name' => 'users',
                'translatable' => false,
                'title' => [
                    'fr' => 'Utilisateur',
                    'en' => 'User',
                    'nl' => 'Gebruiker',
                    'pt' => 'Utilizador',
                    'es' => 'Espace métier',
                    'de' => 'Benutzer',
                ],
            ]
        );
    }
}
