<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditFieldsEditableForLiry extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            'location',
            'teams'
        ];

        foreach ($fields as $field) {
            $bridge->updateFieldOptions(
                type: 'users',
                fieldName: $field,
                options: [
                    'editable' => false,
                ]
            );
        }
    }
}
