<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class LiryMakeProfilEditable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $profileConfiguration = [
            'function' => [
                'required' => true,
                'editable' => false,
                'title' => [
                    'fr' => 'Fonction',
                ]
            ],
            'poles' => [
                'required' => true,
                'editable' => false,
                'title' => [
                    'fr' => 'Pôle',
                ]
            ],
            'teams' => [
                'required' => false,
                'editable' => true,
                'title' => [
                    'fr' => 'Équipe',
                ]
            ],
            'location' => [
                'required' => true,
                'editable' => true,
                'title' => [
                    'fr' => 'Lieu de travail',
                ]
            ],
            'phone' => [
                'required' => false,
                'editable' => true,
                'title' => [
                    'fr' => 'Téléphone fixe',
                ]
            ],
            'mobile_phone' => [
                'required' => false,
                'editable' => true,
                'title' => [
                    'fr' => 'Téléphone mobile',
                ]
            ],
            'preferred_language' => [
                'required' => false,
                'editable' => true,
                'title' => [
                    'fr' => 'Langue préférée',
                ]
            ],
            'link' => [
                'required' => false,
                'editable' => true,
                'title' => [
                    'fr' => 'Lien URL',
                ]
            ],
        ];

        foreach ($profileConfiguration as $field => $config) {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'users',
                fieldName: $field,
                options: [
                    'name' => $field,
                    'required' => $config['required'],
                    'editable' => $config['editable'],
                    'title' => $config['title'],
                ]
            );
        }
    }
}
