<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Seeders\AdsCustomPagesSeeder;
use Inside\Content\Facades\ContentBlueprints;
use Illuminate\Support\Facades\Artisan;

class InstallPostingsModules extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        ContentBlueprints::generateContent(contentType: 'postings_categories');
        ContentBlueprints::generateContent(contentType: 'postings');
        $this->finishUp();

        Artisan::call("models:rebuild");
        (new AdsCustomPagesSeeder())->run();
    }
}
