<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class TranslateAllTranslatableContentsType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $translation = [
            "blocks" => [
                "nl" => "Blok",
                "de" => "Block",
                "es" => "Bloquear",
                "fr" => "Bloc",
                "en" => "Block",
                "pt" => "Bloco",
            ],
            "cards_links" => [
                "nl" => "Afbeelding met link",
                "de" => "Bild mit Link",
                "es" => "Imagen con enlace",
                "fr" => "Image avec lien",
                "en" => "Image with link",
                "pt" => "Imagem com link",
            ],
            "connexion_popups" => [
                "nl" => "Inlogvenster",
                "de" => "Login-Popup",
                "es" => "Ventana emergente de inicio de sesión",
                "fr" => "Popin de connexion",
                "en" => "Login popup",
                "pt" => "Janela de login",
            ],
            "custom" => [
                "nl" => "Pagina op maat",
                "de" => "Benutzerdefinierte Seite",
                "es" => "Página personalizada",
                "fr" => "Page personnalisée",
                "en" => "Custom page",
                "pt" => "Página personalizada",
            ],
            "dms_link" => [
                "nl" => "Link",
                "de" => "Link",
                "es" => "Enlace",
                "fr" => "Lien",
                "en" => "Link",
                "pt" => "Link",
            ],
            "documents" => [
                "nl" => "Document",
                "de" => "Dokumentieren",
                "es" => "Documento",
                "fr" => "Document",
                "en" => "Document",
                "pt" => "Documento",
            ],
            "events" => [
                "nl" => "Evenement",
                "de" => "Vorfall",
                "es" => "Evento",
                "fr" => "Événement",
                "en" => "Event",
                "pt" => "Evento",
            ],
            "events_categories" => [
                "nl" => "Categorie evenement",
                "de" => "Veranstaltungskategorie",
                "es" => "Categoría de evento",
                "fr" => "Catégorie d'événement",
                "en" => "Event category",
                "pt" => "Categoria do evento",
            ],
            "faq_categories" => [
                "nl" => "Categorie Veelgestelde vragen",
                "de" => "Häufig gestellte Fragen zu Kategorien",
                "es" => "Preguntas frecuentes sobre la categoría",
                "fr" => "Catégorie FAQ",
                "en" => "FAQ category",
                "pt" => "Perguntas frequentes da categoria",
            ],
            "faq_questions" => [
                "nl" => "Vraag FAQ",
                "de" => "Question FAQ",
                "es" => "Preguntas frecuentes",
                "fr" => "Question FAQ",
                "en" => "Question FAQ",
                "pt" => "Perguntas frequentes",
            ],
            "flash_news" => [
                "nl" => "Nieuwsflitsing",
                "de" => "Newsflash",
                "es" => "Noticia de última hora",
                "fr" => "Flash info",
                "en" => "Newsflash",
                "pt" => "Novidades",
            ],
            "folders" => [
                "nl" => "Geval",
                "de" => "Mappe",
                "es" => "Carpetas",
                "fr" => "Dossier",
                "en" => "Folder",
                "pt" => "Caso",
            ],
            "movements" => [
                "nl" => "Bewegingen",
                "de" => "Bewegungen",
                "es" => "Movimientos",
                "fr" => "Mouvements",
                "en" => "Movements",
                "pt" => "Movimentos",
            ],
            "movements_categories" => [
                "nl" => "Categorie beweging",
                "de" => "Bewegungskategorie",
                "es" => "Categoría de movimiento",
                "fr" => "Catégorie de mouvement",
                "en" => "Movement category",
                "pt" => "Categoria de movimento",
            ],
            "news" => [
                "nl" => "Nieuws",
                "de" => "Nachrichten",
                "es" => "Noticias",
                "fr" => "Actualité",
                "en" => "News",
                "pt" => "Notícias",
            ],
            "news_categories" => [
                "nl" => "Nieuwscategorie",
                "de" => "Nachrichten-Kategorie",
                "es" => "Categoría de noticias",
                "fr" => "Catégorie d'actualité",
                "en" => "News Category",
                "pt" => "Categoria de notícias",
            ],
            "pages" => [
                "nl" => "Enkele pagina",
                "de" => "Einzelne Seite",
                "es" => "Una sola página",
                "fr" => "Page simple",
                "en" => "Single page",
                "pt" => "Página única",
            ],
            "public_pages" => [
                "nl" => "Openbare pagina",
                "de" => "Öffentliche Seite",
                "es" => "Pagina publica",
                "fr" => "Page publique",
                "en" => "Public page",
                "pt" => "Página pública",
            ],
            "tabs" => [
                "nl" => "Tab",
                "de" => "Tab",
                "es" => "Pestaña",
                "fr" => "Onglet",
                "en" => "Tab",
                "pt" => "Guia",
            ],
            "tabs_pages" => [
                "nl" => "Tabblad Subpagina",
                "de" => "Registerkarte „Unterseite“.",
                "es" => "Pestaña de subpágina",
                "fr" => "Sous Page Onglet",
                "en" => "Sub Page Tab",
                "pt" => "Na guia da página",
            ],
            "tabs_spaces" => [
                "nl" => "Tabbladen",
                "de" => "Tabulator-Leerzeichen",
                "es" => "Espacios de tabulación",
                "fr" => "Espace à onglets",
                "en" => "Tab spaces",
                "pt" => "Espaço com guias",
            ],
            "tools" => [
                "nl" => "Hulpmiddel",
                "de" => "Werkzeug",
                "es" => "Herramienta",
                "fr" => "Outil",
                "en" => "Tool",
                "pt" => "Ferramenta",
            ],
            "tools_categories" => [
                "nl" => "Categorie gereedschap",
                "de" => "Werkzeugkategorie",
                "es" => "Categoría de herramienta",
                "fr" => "Catégorie d'outil",
                "en" => "Tool category",
                "pt" => "Categoria de ferramenta",
            ],
            "tools_categories_listings" => [
                "nl" => "Lijst van gereedschapscategorieën",
                "de" => "Werkzeugkategorienliste",
                "es" => "Listado de categorías de herramientas",
                "fr" => "Listing catégorie d'outils",
                "en" => "Tools categories listing",
                "pt" => "Listagem de categorias de ferramentas",
            ],
            "top_footer" => [
                "nl" => "Op voettekst",
                "de" => "In der Fußzeile",
                "es" => "En pie de página",
                "fr" => "Sur footer",
                "en" => "On footer",
                "pt" => "No rodapé",
            ],
        ];

        foreach ($translation as $type => $translations) {
            $bridge->changeContentTypeTitle($type, $translations);
        }

        Artisan::call('models:rebuild');
    }
}
