<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'spaces_pages_categories',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Regroupement de page widget',
            'en' => 'Widget page grouping',
            'nl' => 'Widget pagina groepering',
            'pt' => 'Agrupamento de página de widget',
            'es' => 'Agrupación de página de widget',
            'de' => 'Widget-Seitengruppierung',
        ],
    ],
    'fields' => [
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Icone',
                'en' => 'Icon',
                'nl' => 'Icoon',
                'pt' => 'Ícone',
                'es' => 'Icono',
                'de' => 'Symbol',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'icon_color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Couleur de l\'icône',
                'en' => 'Icon color',
                'nl' => 'Icoon kleur',
                'pt' => 'Cor do ícone',
                'es' => 'Color del icono',
                'de' => 'Symbolfarbe',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'nl' => 'Afbeelding',
                'pt' => 'Imagem',
                'es' => 'Imagen',
                'de' => 'Bild',
            ],
            'description' => [
                'fr' => 'Cette image remontera comme une bannière du bloc',
                'en' => 'This image will appear as a banner of the block',
                'nl' => 'Deze afbeelding verschijnt als een banner van de blok',
                'pt' => 'Esta imagem aparecerá como um banner do bloco',
                'es' => 'Esta imagen aparecerá como un banner del bloque',
                'de' => 'Dieses Bild wird als Banner des Blocks angezeigt',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'spaces',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Espace',
                'en' => 'Space',
                'nl' => 'Ruimte',
                'pt' => 'Espaço',
                'es' => 'Espacio',
                'de' => 'Raum',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace dans laquelle le regroupement doit remonter',
                'en' => 'Select the space in which the grouping should appear',
                'nl' => 'Kies de ruimte waarin de groepering moet verschijnen',
                'pt' => 'Selecione o espaço em que o agrupamento deve aparecer',
                'es' => 'Seleccione el espacio en el que debe aparecer el agrupamiento',
                'de' => 'Wählen Sie den Raum aus, in dem die Gruppierung angezeigt werden soll',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['spaces'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de exibição',
                'es' => 'Orden de visualización',
                'de' => 'Reihenfolge anzeigen',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number appears first',
                'nl' => 'Het laagste getal verschijnt eerst',
                'pt' => 'O número mais baixo aparece primeiro',
                'es' => 'El número más bajo aparece primero',
                'de' => 'Die niedrigste Zahl erscheint zuerst',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
