<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'spaces_pages',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Page widget',
            'en' => 'Widget page',
            'nl' => 'Widget pagina',
            'pt' => 'Página de widget',
            'es' => 'Página de widget',
            'de' => 'Widget-Seite',
        ],
    ],
    'fields' => [
        [
            'name' => 'spaces_pages_categories',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Regroupement de page',
                'en' => 'Page grouping',
                'nl' => 'Paginagroepering',
                'pt' => 'Agrupamento de página',
                'es' => 'Agrupación de página',
                'de' => 'Seitengruppierung',
            ],
            'description' => [
                'fr' => 'Choix du regroupement de page dans lequel la page doit remonter',
                'en' => 'Select the page grouping in which the page should appear',
                'nl' => 'Selecteer de paginagroepering waarin de pagina moet verschijnen',
                'pt' => 'Escolha o agrupamento de página no qual a página deve aparecer',
                'es' => 'Elija la agrupación de página en la que la página debe aparecer',
                'de' => 'Wählen Sie die Seitengruppierung, in der die Seite erscheinen soll',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['spaces_pages_categories'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de exibição',
                'es' => 'Orden de visualización',
                'de' => 'Anzeigereihenfolge',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number appears first',
                'nl' => 'Het laagste getal verschijnt eerst',
                'pt' => 'O menor número aparece primeiro',
                'es' => 'El número más bajo aparece primero',
                'de' => 'Die niedrigste Zahl erscheint zuerst',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'nl' => 'Inhoud',
                'pt' => 'Conteúdo',
                'es' => 'Contenido',
                'de' => 'Inhalt',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
                'en' => 'Select the different types of paragraphs you want to display on the page',
                'nl' => 'Selecteer de verschillende soorten paragrafen die u op de pagina wilt weergeven',
                'pt' => 'Selecione os diferentes tipos de parágrafos que deseja exibir na página',
                'es' => 'Seleccione los diferentes tipos de párrafos que desea mostrar en la página',
                'de' => 'Wählen Sie die verschiedenen Absatztypen aus, die Sie auf der Seite anzeigen möchten',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
