<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'movements_categories',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Catégorie de mouvement',
            'en' => 'Movement category',
            'es' => 'Categorías de movimiento',
            'de' => 'Bewegungskategorien',
            'pt' => 'Categoria de movimento',
            'nl' => 'Bewegingscategorie',
        ],
    ],
    'fields' => [
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'default' => null,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'es' => 'Color',
                'de' => 'Farbe',
                'pt' => 'Cor',
                'nl' => 'Kleur',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'button_text',
            'searchable' => false,
            'translatable' => true,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Texte du bouton',
                'en' => 'Button Text',
                'es' => 'Texto del botón',
                'de' => 'Schaltflächentext',
                'pt' => 'Texto do botão',
                'nl' => 'Knop tekst',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
