<?php

use Inside\Content\Models\Contents\Users;

return [
    'files' => [
        'liry' => [
            'path' => env('CSV_USERS_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => env('CSV_USERS_SEPARATOR', ','),
            'fields' => [
                'email' => 'email',
                'name' => 'email',
                'firstname' => 'prénom',
                'lastname' => 'nom',
                'function' => 'fonction',
                'preferred_language' => fn ($user) => reference('preferred_language')
                    ->identifiedBy('code')
                    ->from(ucfirst($user['langue préférée']))
                    ->get(),
                'poles' => fn ($user) => reference('poles')
                    ->identifiedBy('code')
                    ->from(ucfirst($user['pôle']))
                    ->get(),
                'teams' => fn ($user) => reference('teams')
                    ->identifiedBy('code')
                    ->from(ucfirst($user['équipe']))
                    ->get(),
                'project' => 'projet',
                'location' => 'localisation',
                'phone' => 'téléphone fixe',
                'mobile_phone' => 'téléphone mobile',
                'link' => 'lien URL',
                'status' => fn () => true,
                'is_maintenance' => fn () => false,
                'send_mail' => fn ($record): bool => Users::where('email', $record['office_email'])->doesntExist(),
            ],
            'original_fields' => [
                'email' => 'mail',
                'prénom' => 'firstname',
                'nom'  => 'lastname',
                'fonction' => 'function',
                'pôle' => 'word',
                'équipe' => 'word',
                'projet' => 'word',
                'localisation' => 'word',
                'téléphone fixe' => 'word',
                'téléphone mobile' => 'word',
                'langue préférée' => 'word',
                'lien URL' => 'word'
            ],
        ],
    ],
];
