import { withFetch } from 'inside-collection/hocs'

import { fetchFullGroup, fetchGroup } from '@inside-teams/fetch'
import { fetchEventSpaces, fetchSupplies } from '../fetch'

import { suppliesOrdersGuard } from '../guards'

import GroupEventPage from '../pages/groups/GroupEventPage'

import TeamEventPage from '../pages/teams/TeamEventPage'
import TeamMembersPage from '../pages/teams/TeamMembersPage'
import TeamPage from '../pages/teams/TeamPage'

import OrderFormPage from '../pages/supplies/OrderFormPage'

import RestaurantsPage from '../pages/restaurants/RestaurantsPage'
import { fetchDishesCategories } from '../components/restaurants/fetch.js'

import teamMiddleware from '@inside-teams/middlewares'

import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    component: () => import('../pages/GedPage'),
    meta: { disabled: false }
  },
  {
    name: 'TeamsListingPage',
    props: {
      bannerData: {
        html: true,
        add: ['groups', 'groups_events', 'groups_documents']
      }
    }
  },
  {
    name: 'TeamEventsPage',
    meta: { disabled: false },
    props: {
      bannerData: {
        page: 'groups-calendar',
        add: ['groups_events'],
        html: true
      }
    }
  },
  {
    name: 'TeamEventPage',
    meta: { disabled: false },
    component: withFetch(TeamEventPage, { size: 'xxl' })(fetchGroup)
  },
  {
    name: 'TeamMembersPage',
    component: withFetch(TeamMembersPage, { size: 'xxl' })(fetchGroup)
  },
  {
    name: 'TeamPage',
    component: withFetch(TeamPage, { size: 'xxl' })(fetchFullGroup)
  },
  {
    name: 'GroupsPage',
    path: '/groups',
    component: () => import('../pages/groups/GroupsPage')
  },
  {
    name: 'GroupPage',
    path: '/groups/:slug',
    component: () => import('../pages/groups/GroupPage')
  },
  {
    name: 'GroupMembersPage',
    component: () => import('../pages/groups/GroupMembersPage'),
    path: '/groups/:slug/members'
  },
  {
    name: 'GroupEventPage',
    component: withFetch(GroupEventPage, { size: 'xxl' })(fetchEventSpaces),
    path: '/groups/:slug/events/:event'
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    component: () => import('../pages/events/EventPage'),
    meta: { disabled: false }
  },
  {
    name: 'EventRegisterPage',
    path: '/events/:slug/register',
    component: () => import('../pages/events/EventRegisterPage'),
    meta: { contentType: 'events' }
  },
  {
    name: 'EventFeedbackPage',
    path: '/events/:event/feedback',
    component: () => import('../pages/events/EventFeedbackPage'),
    meta: { contentType: 'events' }
  },
  {
    name: 'EventFeedbacksListingPage',
    path: '/events/:event/feedbacks',
    component: () => import('../pages/events/EventFeedbacksListingPage'),
    meta: { contentType: 'events' }
  },
  {
    name: 'EventParticipantsPage',
    path: '/events/:event/participants',
    component: () => import('../pages/events/EventParticipantsPage'),
    meta: { contentType: 'events' }
  },
  {
    name: 'TeamEventRegisterPage',
    path: '/__TEAMS__/:slug/events/:event/register',
    component: () => import('../pages/events/EventRegisterPage'),
    meta: { contentType: 'groups_events', middleware: teamMiddleware }
  },
  {
    name: 'TeamEventFeedbackPage',
    path: '/__TEAMS__/:slug/events/:event/feedback',
    component: () => import('../pages/events/EventFeedbackPage'),
    meta: { contentType: 'groups_events', middleware: teamMiddleware }
  },
  {
    name: 'TeamEventFeedbacksListingPage',
    path: '/__TEAMS__/:slug/events/:event/feedbacks',
    component: () => import('../pages/events/EventFeedbacksListingPage'),
    meta: { contentType: 'groups_events', middleware: teamMiddleware }
  },
  {
    name: 'TeamEventParticipantsPage',
    path: '/__TEAMS__/:slug/events/:event/participants',
    component: () => import('../pages/events/EventParticipantsPage'),
    meta: { contentType: 'groups_events', middleware: teamMiddleware },
    props: { component: 'listing' }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/news/NewsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    component: () => import('../pages/news/NewsPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    component: () => import('../pages/tools/ToolsPage'),
    path: '/tools',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'FormsListingPage',
    path: '/forms',
    component: () => import('../pages/FormsListingPage')
  },
  {
    name: 'ActivitiesListingPage',
    path: '/activities',
    component: () => import('../pages/ActivitiesListingPage')
  },
  {
    name: 'RotationsListingPage',
    path: '/rotations',
    component: () => import('../pages/RotationsListingPage')
  },
  {
    name: 'OrderFormPage',
    path: {
      en: '/supplies-order'
    },
    component: withFetch(OrderFormPage, { size: 'xxl' })(fetchSupplies),
    meta: { customSlug: 'orders-form' }
  },
  {
    name: 'MyOrdersPage',
    path: {
      en: '/supplies-order/my-orders'
    },
    component: () => import('../pages/supplies/MyOrdersPage'),
    meta: { customSlug: 'my-orders' }
  },
  {
    name: 'OrdersListingPage',
    path: {
      en: '/supplies-order/orders-listing'
    },
    component: () => import('../pages/supplies/OrdersListingPage'),
    meta: { customSlug: 'orders-listing', middleware: suppliesOrdersGuard }
  },
  {
    name: 'RoomReservationPage',
    path: {
      en: '/room-reservations'
    },
    component: () => import('../pages/reservations/RoomReservationPage'),
    meta: { customSlug: 'room-reservations' }
  },
  {
    name: 'AllReservationsListingPage',
    path: {
      en: '/all-reservations'
    },
    component: () => import('../pages/reservations/AllReservationsListingPage'),
    meta: { customSlug: 'all-reservations' }
  },
  {
    name: 'RestaurantsPage',
    path: {
      en: '/restaurants'
    },
    component: withFetch(RestaurantsPage, { size: 'xxl' })(
      fetchDishesCategories
    )
  },
  {
    name: 'RestaurantOrdersPage',
    path: {
      en: '/restaurants/my-orders'
    },
    component: () => import('../pages/restaurants/RestaurantOrdersPage')
  },
  {
    name: 'RestaurantAdminPage',
    path: {
      en: '/restaurants/admin'
    },
    component: () => import('../pages/restaurants/RestaurantAdminPage')
  },
  {
    name: 'UsersCreditsPage',
    path: {
      en: '/credits'
    },
    component: () => import('../pages/restaurants/UsersCreditsPage')
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
