export default {
  globals: {
    dates: {
      LT: 'HH:mm',
      L: 'DD/MM/YYYY',
      LL: 'D MMMM YYYY',
      LLL: 'D MMMM YYYY',
      LLLL: 'dddd D MMMM YYYY',
      l: 'D MMMM YYYY',
      ll: 'D MMMM YYYY',
      lll: 'D MMM YYYY',
      llll: 'D MMMM YYYY'
    },
    notificationRedirectionsContentTypes: ['events'],
    notificationRedirections: {
      events: ({ data }) => ({
        name: 'EventPage',
        params: { event: data.slug[0] }
      })
    }
  },
  'inside-birthdays': {
    dateFormat: 'D MMMM'
  },
  'inside-users': {
    allowAvatarEdition: false,
    login: {
      useGradient: false,
      useImage: true
    },
    shortcuts: {
      max: 8,
      readonlyCount: 2
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    }
  },
  'inside-news': {
    showBookmarks: false,
    templates: {
      fullContent: {
        mainComponent: () => import('./components/news/FullNews')
      }
    },
    authorEnabled: true
  },
  'inside-agenda': {
    showAddReservationButton: false,
    showTodayButton: false,
    allowedViews: ['day'],
    activeView: 'day',
    splitDays: true
  },
  'inside-forms': {
    surveyDisabledInputs: ['input-on-off'],
    formDisabledInputs: ['input-on-off'],
    fields: {
      calendar: {
        mondayFirst: {
          en: true
        }
      }
    }
  },
  'inside-maps': {
    editionDefaultLatitude: 50.8445243,
    editionDefaultLongitude: 4.3547014
  },
  'inside-teams': {
    rootRoute: {
      en: 'spaces'
    }
  },
  'inside-tools': {
    rootRoute: {
      en: 'toolbox'
    }
  }
}
