import { storage } from '@inside-library/helpers/Storage'
import { isSuperAdmin } from '@inside-library/helpers/Rights'

export const suppliesOrdersGuard = async ({ router }) => {
  const user = storage.get('current-user')

  if (isSuperAdmin()) {
    return
  }

  if (!user.permissions.roles.includes('facilities_team')) {
    router.push({
      name: 'ErrorPage',
      params: {
        code: '403'
      }
    })
  }
}
