import { http } from '@inside-library/helpers/Http'

const fetchDishesCategories = async () => {
  try {
    const { data } = await http.get('content/dishes_categories', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        {
          dishes: {
            fields: [
              'uuid',
              'title',
              'price',
              'status',
              {
                weekdays: {
                  fields: ['uuid', 'title']
                }
              }
            ],
            filters: { 'status:eq': 1, reverse: true }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'published_at:lte': 'now()',
        sort: 'weight:asc'
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchDishesCategories }
