export default {
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] }
    ]
  },
  groups_documents: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'lastname',
      'firstname',
      'email',
      'name',
      'image',
      'birthday',
      'gsm',
      'direct_line',
      'linkedin_link',
      'office',
      'start_date',
      'username',
      'job_title',
      { floor_maps: ['image'] },
      { languages: ['title'] },
      { locations: ['title', 'uuid'] },
      {
        main_assistant_to: {
          fields: ['uuid', 'firstname', 'lastname', 'direct_line', 'image'],
          filters: { alias: 'mainAssistant' }
        }
      },
      {
        main_assistant_to: {
          fields: ['uuid', 'firstname', 'lastname', 'direct_line', 'image'],
          filters: { reverse: true, alias: 'mainAssistantTo' }
        }
      },
      {
        personnal_assistant_to: {
          fields: ['uuid', 'firstname', 'lastname', 'direct_line', 'image'],
          filters: { reverse: true, alias: 'assistants' }
        }
      },
      {
        personnal_assistant_to: [
          'uuid',
          'firstname',
          'lastname',
          'direct_line',
          'image'
        ]
      },
      { spaces: ['uuid', 'title', 'slug'] },
      { expertises: ['title'] },
      { users_status: ['title'] }
    ]
  },
  dishes: {
    specificPage: {
      fr: 'restaurants'
    }
  },
  dishes_categories: {
    specificPage: {
      fr: 'restaurants'
    }
  },
  dishes_orders: {
    editionDisabled: true,
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'cost',
      'date',
      'order',
      'comment',
      { dishes_orders_status: ['uuid', 'title', 'color'] },
      { authors: ['uuid', 'firstname', 'lastname', 'image'] }
    ]
  },
  events_subscriptions: {
    editionDisabled: true
  },
  register_forms: {
    editionDisabled: true
  },
  events_feedbacks: {
    editionDisabled: true
  },
  rooms_reservations: {
    editionDisabled: true,
    modalFields: [
      'uuid',
      'title',
      'reservation_description',
      { rooms: ['uuid', 'title', { rooms_category: ['uuid', 'title'] }] },
      'content_type',
      'published_at',
      'start_date',
      'end_date',
      'external_users',
      'cooldown',
      'admin',
      'frequency',
      'internal_comment',
      'readiness_status',
      'seats',
      { information_technologies: ['uuid', 'title'] },
      { catering_services: ['uuid', 'title'] },
      { internal_users: ['uuid', 'firstname', 'lastname', 'image'] },
      { authors: ['uuid', 'firstname', 'lastname', 'image'] },
      { organizer: ['uuid', 'firstname', 'lastname', 'image'] }
    ]
  },
  rooms: {
    specificPage: {
      en: 'room-reservations-1'
    }
  }
}
