import { markRaw } from 'vue'

import { BaseText } from 'inside-collection/atoms'

export default {
  $_i18nRootPath: 'customs.SUPPLIES.myOrders',
  components: { BaseText },
  methods: {
    scaffoldRows(fields) {
      return [
        {
          id: 'date',
          tag: 'date-ui',
          data: { date: fields.published_at }
        },
        {
          id: 'products',
          tag: markRaw(BaseText),
          value: JSON.parse(fields.quantity)
            .filter(({ quantity }) => quantity > 0)
            .map(({ title, quantity }) => `${title} (${quantity})`)
            .join('<br>'),
          data: { html: true }
        },
        {
          id: 'comments',
          tag: markRaw(BaseText),
          value: fields.description
        }
      ]
    }
  },
  computed: {
    filters() {
      return [
        {
          modelName: 'date',
          type: 'day',
          label: this.$_tr('filters.publishedAt'),
          filterOn: 'published_at',
          callback: item => ({
            ...(item && {
              'published_at:gte': `${item} 00:00:00`,
              'published_at:lte': `${item} 23:59:59`
            })
          })
        }
      ]
    },
    headers() {
      return [
        {
          id: 'date',
          value: this.$_tr('headers.date'),
          key: 'published_at',
          default: true,
          sortable: true,
          order: 'desc'
        },
        {
          id: 'products',
          value: this.$_tr('headers.products')
        },
        {
          id: 'comments',
          value: this.$_tr('headers.comments')
        }
      ]
    }
  }
}
