import { markRaw } from 'vue'

import { BaseText } from 'inside-collection/atoms'

export default {
  $_i18nRootPath: 'customs.SUPPLIES.allOrders',
  components: { BaseText },
  methods: {
    scaffoldRows(fields) {
      return [
        {
          id: 'user',
          value: this.$_username(fields.authors)
        },
        {
          id: 'date',
          tag: 'date-ui',
          data: { date: fields.published_at }
        },
        {
          id: 'products',
          tag: markRaw(BaseText),
          value: JSON.parse(fields.quantity)
            .filter(({ quantity }) => quantity > 0)
            .map(({ title, quantity }) => `${title} (${quantity})`)
            .join(', '),
          data: { html: true }
        },
        {
          id: 'comments',
          tag: markRaw(BaseText),
          value: fields.description
        }
      ]
    }
  },
  computed: {
    filters() {
      return [
        {
          modelName: 'search',
          type: 'text',
          placeholder: this.$_tr('filters.name'),
          searchIn: ['orders']
        },
        {
          modelName: 'date',
          type: 'day',
          label: this.$_tr('filters.publishedAt'),
          filterOn: 'published_at',
          callback: item => ({
            ...(item && {
              'published_at:gte': `${item} 00:00:00`,
              'published_at:lte': `${item} 23:59:59`
            })
          })
        }
      ]
    },
    headers() {
      return [
        {
          id: 'authors',
          value: this.$_tr('headers.authors')
        },
        {
          id: 'publishedAt',
          value: this.$_tr('headers.publishedAt'),
          key: 'published_at',
          default: true,
          sortable: true,
          order: 'desc'
        },
        {
          id: 'products',
          value: this.$_tr('headers.products')
        },
        {
          id: 'comments',
          value: this.$_tr('headers.comments')
        }
      ]
    }
  }
}
