import RRule from 'rrule'

import {
  FREQUENCIES,
  frequenciesValues
} from '@inside-agenda/constants/recurrence-constants'

export default {
  computed: {
    /*
     * Parse a frequency string into rrule options
     */
    parseFrequency() {
      return frequency => {
        return frequency ? RRule.parseString(frequency) : null
      }
    }
  },
  methods: {
    findFrequencyLabel(freqKey) {
      return frequenciesValues.find(freq => {
        return freq.value === FREQUENCIES[freqKey]
      }).labelKey
    },
    /*
     * Set the right frequency in the frequency selectbox from a RRule string
     *
     * @param {object} options
     */
    currentFrequency(options) {
      if (!options) return frequenciesValues[0].labelKey

      if (options.freq === RRule.DAILY) {
        return this.findFrequencyLabel('DAILY')
      }

      if (options.freq === RRule.WEEKLY) {
        if (options.interval === 2) {
          return this.findFrequencyLabel('BIMONTHLY')
        }
        if (options.interval === 4) {
          return this.findFrequencyLabel('MONTHLY')
        }

        return this.findFrequencyLabel('WEEKLY')
      }

      return this.findFrequencyLabel('ONCE')
    }
  }
}
