import insideConfig from './inside.config.js'
import i18n from './i18n'
import redirections from './redirections'
import routes from './router'

import AgendaModal from '../inside-overrides/agenda/AgendaModal'
import FullAgenda from '../inside-overrides/agenda/FullAgenda'
import ReservationsFields from '../inside-overrides/agenda/ReservationsFields'
import ReservationsForm from '../inside-overrides/agenda/ReservationsForm'
import ReservationsFormModal from '../inside-overrides/agenda/ReservationsFormModal'
import ReservationsPopupContent from '../inside-overrides/agenda/ReservationsPopupContent'
import UserModal from '../inside-overrides/users/UserModal'

export default {
  name: 'inside-customs',
  init: app => {
    app.component('agenda-modal', AgendaModal)
    app.component('full-agenda', FullAgenda)
    app.component('reservations-fields', ReservationsFields)
    app.component('reservations-form', ReservationsForm)
    app.component('reservations-form-modal', ReservationsFormModal)
    app.component('reservations-popup-content', ReservationsPopupContent)
    app.component('user-modal', UserModal)
  },
  insideConfig,
  i18n,
  redirections,
  routes
}
