import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import RestaurantsOrderModal from '../components/restaurants/modals/RestaurantsOrderModal'
import RestaurantsCreditsModal from '../components/restaurants/modals/RestaurantsCreditsModal'
import ReservationModal from '../components/reservations/ReservationModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('restaurants-order-modal', RestaurantsOrderModal)
    app.component('restaurants-credits-modal', RestaurantsCreditsModal)
    app.component('reservation-modal', ReservationModal)
  })
}
