<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\LIED\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get(
            'reservations/list/index',
            [
                'uses' => 'RoomReservationController@index',
                'as'   => 'lied.reservation.index',
            ]
        );

        $router->post('reservations/export', ['uses' => 'RoomReservationController@export']);

        $router->get('catering/credits/permissions', ['uses' => 'PermissionController@CanUpdate']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\LIED\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.role:catering_services_team|super_administrator']
    ],
    function ($router) {
        $router->post('catering/credits', ['uses' => 'PermissionController@updateCredits']);
    }
);
