<?php

namespace Inside\LIED\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RegisterEventForm3 extends RegisterBaseForm
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_register_event_form_3';

    /**
     * Casts the following attributes
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_uuid',
        'langcode',
        'event_uuid',
        'message',
        'dietary_requirements',
        'transport_uuid'
    ];

    /**
     * The transport used.
     */
    public function transport(): BelongsTo
    {
        return $this->belongsTo('Inside\Content\Models\Contents\Transports', 'transport_uuid', 'uuid');
    }
}
