<?php

namespace Inside\LIED\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class FeedbackBaseForm extends Model
{
    /**
     * The user that owns the answer.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo('Inside\Content\Models\Contents\Users', 'user_uuid', 'uuid');
    }

    /**
     * The events linked to this answer
     */
    public function event(): BelongsTo
    {
        return $this->belongsTo('Inside\Content\Models\Contents\Events', 'event_uuid', 'uuid');
    }
}
