<?php

namespace Inside\LIED\Listeners;

use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Events;
use Inside\LIED\Events\EventFinishedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class EventFinishedListener extends BaseNotificationListener
{
    public function handle(EventFinishedEvent $event): void
    {
        $evenement = Events::find($event->event->uuid);
        /** @var NotificationType $type */
        $type = NotificationType::where('via', 'email')
            ->where('event', 'Inside\Notify\Events\CustomNotificationEvent')
            ->where('model', 'Inside\Content\Models\Contents\Events')
            ->where('action', 'feedback')
            ->where('type', 'system')->first();
        $evenement->reverseEventsSubscriptions->each(
            function ($subscription) use ($type, $evenement) {
                /** @var User $subscriber */
                $subscriber = User::find($subscription->author);
                $this->route = $subscriber;
                $this->notify($type, $subscriber, $evenement, ['url' => 'events/' . $evenement->slug[0] . '/feedback']);
            }
        );
    }
}
