<?php

namespace Inside\LIED\Listeners;

use Illuminate\Support\Collection;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\LIED\Notifications\EventsSubscriptionNotification;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\Authentication\Models\User;
use Inside\Permission\Models\Role;
use Illuminate\Support\Facades\Notification;

/**
 * Inside package content service.
 *
 * @category Class
 * @package  Inside\LIED\Listeners\ContentUpdatedListener
 * @author   Thomas Huang <thomas.huang@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentInsertedListener extends BaseNotificationListener
{
    public function handle(ContentInsertedEvent $event): void
    {
        $model = $event->model;

        if (get_class($model) === 'Inside\Content\Models\Contents\DishesOrders') {
            /** @var Collection<NotificationType> $types */
            $types = NotificationType::where('model', get_class($model))->where(function ($query) {
                $query->where('action', 'dishes');
            })->get();

            $author = $model->author;

            /** @var Role $role */
            $role = Role::where('name', 'catering_services_team')->first();

            foreach ($role->users as $user) {
                foreach ($types as $type) {
                    /** @var User $subscriber */
                    $subscriber = User::find($user->uuid);
                    $this->when = $this->getInterval($type, $model);
                    $this->route = $subscriber;
                    $this->notify(
                        $type,
                        $subscriber,
                        $model,
                        [
                            'from' => $author,
                        ]
                    );
                }
            }
        }

        if (get_class($model) === "Inside\Content\Models\Contents\EventsSubscriptions") {
            /** @var User $subscriber */
            $subscriber = User::find($model->author);

            $event = $model->events->first();
            if (!$event) {
                $event = $model->groupsEvents->first();
            }

            /** @var NotificationType $type */
            $type = NotificationType::query()->where('via', 'email')
                ->where('event', 'Inside\Notify\Events\CustomNotificationEvent')
                ->where('action', 'registerEvent')
                ->where('type', 'system')->first();

            Notification::send(
                $subscriber,
                (new EventsSubscriptionNotification($type, $subscriber, $event))->withIcs()
            );
        }
    }
}
