<?php

namespace Inside\LIED\Listeners;

use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\LIED\Notifications\EventsSubscriptionNotification;
use Inside\Content\Models\Contents\EventsSubscriptions;
use Inside\Notify\Models\NotificationType;
use Inside\Authentication\Models\User;
use Illuminate\Support\Facades\Notification;

class ContentFullyUpdatedListener
{
    public function handle(ContentFullyUpdatedEvent $event): void
    {
        $model = $event->model;
        $class = (string) get_class($model);
        if (in_array($class, ["Inside\Content\Models\Contents\Events", "Inside\Content\Models\Contents\GroupsEvents"])) {
            if (!$model->notify) {
                return;
            }
            $attribute = class_to_attribute($class);
            $participants = EventsSubscriptions::query()->where(function ($query) use ($model, $attribute) {
                $query->whereHas($attribute, function ($query) use ($model) {
                    $query->where('uuid', $model->uuid);
                });
            })->pluck('author');

            /** @var NotificationType $type */
            $type = NotificationType::query()->where('via', 'email')
                ->where('event', 'Inside\Notify\Events\CustomNotificationEvent')
                ->where('action', 'eventEdited')
                ->where('condition', 'notify:1')->first();

            foreach ($participants as $participant) {
                /** @var User $subscriber */
                $subscriber = User::find($participant);
                Notification::send(
                    $subscriber,
                    (new EventsSubscriptionNotification($type, $subscriber, $model))->withIcs()
                );
            }
        }
    }
}
