<?php

namespace Inside\LIED\Http\Middleware;

use Closure;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Inside\Http\Middleware\TransformResponseAndRequest;

class RemoveNonAvailableServicesOnReservation extends TransformResponseAndRequest
{
    protected array $paths = [
        'GET' => [
            '#^api/v1/form/([^_]+)_reservations(/[\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})?$#iD',
        ],
    ];

    /**
     * @throws Exception
     */
    protected function patch(Request $request, mixed $response, array $data = []): mixed
    {
        $type = $data[1];
        $uuid = $data[2] ?? null;
        if ($uuid) {
            $uuid = substr($uuid, 1);
        }

        if (($data = $this->getData($response)) === null) {
            throw new Exception('missing uuid');
        }
        $cateringServicesField        = $this->getField($data, 'catering_services');
        $informationTechnologiesField = $this->getField($data, 'information_technologies');

        $cateringServicesKey   = array_key_first($cateringServicesField);
        $cateringServicesField = array_first($cateringServicesField);

        $informationTechnologiesKey   = array_key_first($informationTechnologiesField);
        $informationTechnologiesField = array_first($informationTechnologiesField);

        if (!$uuid) {
            $uuid = $request->get('room_uuid');
        }
        $resource = call_user_func(type_to_class($type) . '::find', $uuid);

        if (!$resource || $resource->cateringServices === null) {
            return $response;
        }

        $allowedUuids = $resource->cateringServices->pluck('uuid');
        $values       = &$cateringServicesField['options']['allowed_values']['catering_services']['en'];
        foreach ($values as $key => $value) {
            if (!$allowedUuids->contains($value['uuid'])) {
                unset($values[$key]);
            }
        }

        $data['data'][$cateringServicesKey] = $cateringServicesField;

        if ($resource->informationTechnologies === null) {
            return $response;
        }
        $allowedUuids = $resource->informationTechnologies->pluck('uuid');
        $values       = &$informationTechnologiesField['options']['allowed_values']['information_technologies']['en'];
        foreach ($values as $key => &$value) {
            if (!$allowedUuids->contains($value['uuid'])) {
                unset($values[$key]);
            }
        }

        $data['data'][$informationTechnologiesKey] = $informationTechnologiesField;

        set_response($response, json_encode($data));

        return $response;
    }

    protected function getData(mixed $response): ?array
    {
        $data = json_decode_response($response);
        if (!is_array($data) || !array_key_exists('data', $data) || !is_array($data['data'])) {
            return null;
        }

        return $data;
    }

    protected function getField(array $data, string $fieldName): array
    {
        return Arr::where(
            $data['data'],
            function ($value, $key) use ($fieldName) {
                return array_key_exists('name', $value) && ($value['name'] === $fieldName);
            }
        );
    }
}
