<?php

namespace Inside\LIED\Http\Middleware;

use Illuminate\Http\Request;
use Inside\Content\Models\Contents\Groups;
use Inside\Http\Middleware\TransformResponseAndRequest;
use Inside\Support\Str;

class FixGroupInProfil extends TransformResponseAndRequest
{
    protected array $paths = [
        'GET' => [
            '#^api/v1/form/users/([\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})$#',
        ],
    ];

    protected function patch(Request $request, mixed $response, array $data = []): mixed
    {
        /** @var array $content */
        $content = json_decode_response($response);
        if (!isset($content['data'])) {
            return $response;
        }
        $data = collect($content['data']);
        $groupContactKey = $data->search(
            function ($field) {
                return isset($field['id']) && $field['id'] == 'group_contact';
            }
        );

        if ($groupContactKey === false || !is_array($content['data'][$groupContactKey]['fields'])) {
            return $response;
        }

        $groupFieldKey = collect($data[$groupContactKey]['fields'])->search(
            function ($field) {
                return isset($field['name']) && $field['name'] == 'groups';
            }
        );

        if (
            $groupFieldKey === false
            || !is_array(
                $content['data'][$groupContactKey]['fields'][$groupFieldKey]['allowed_values']['groups']['en']
            )
        ) {
            return $response;
        }

        /** @var string $refererHeader */
        $refererHeader = $request->headers->get('referer');

        if (Str::contains($refererHeader, 'profile?tab=profile')) {
            $content['data'][$groupContactKey]['fields'][$groupFieldKey]['allowed_values']['groups']['en'] =
                Groups::all()->transform(
                    function ($group) {
                        return [
                            'title' => $group->title,
                            'uuid' => $group->uuid,
                        ];
                    }
                )->values();

            $content['data'][$groupContactKey]['fields'][$groupFieldKey]['options']['allowed_values']['groups']['en'] =
                Groups::all()->transform(
                    function ($group) {
                        return [
                            'title' => $group->title,
                            'uuid' => $group->uuid,
                        ];
                    }
                )->values();
        } else {
            unset($content['data'][$groupContactKey]['fields'][$groupFieldKey]);
        }

        set_response($response, $content);

        return $response;
    }
}
