<?php

namespace Inside\LIED\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\LIED\Facades\Reservations;
use Inside\Permission\Exceptions\AuthorizationException;
use Inside\Permission\Facades\Permission;
use Laravel\Lumen\Routing\Controller;

class RoomReservationController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $date = $request->get('date');

        return response()->json(
            Reservations::getReservationsList(
                ContentHelper::extractFiltersInputFromRequest($request),
                ContentHelper::extractFieldsInputFromRequest($request)
            )
        );
    }

    /**
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function export(Request $request): JsonResponse
    {
        // Assuming that to be allowed to export you must be allowed to create a $type content
        if (!Permission::allowed('create', 'rooms_reservations')) {
            throw AuthorizationException::create('export', 'rooms_reservations');
        }

        return response()->json(['success' => Reservations::export()]);
    }
}
