<?php

namespace Inside\LIED\Http\Controllers;

use Illuminate\Auth\AuthenticationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Host\Bridge\BridgeContent;
use Laravel\Lumen\Routing\Controller;
use Illuminate\Support\Facades\Validator;
use Inside\Content\Exceptions\ValidatorException;
use Inside\Content\Models\Contents\Users;
use Inside\Permission\Models\User;
use Inside\Authentication\Models\User as AuthUser;

class PermissionController extends Controller
{
    /**
     * Create a new form controller instance.
     */

    public function __construct()
    {
    }

    /**
     * Update Catering field
     *
     * @param Request $request
     *
     * @return array
     * @throws ValidatorException
     */
    public function updateCredits(Request $request)
    {
        $rules = [
            'uuid' => ['required'],
            'credits' => ['numeric', 'required'],
        ];
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            throw new ValidatorException($validator->errors());
        }

        $uuid = $request->get('uuid');
        $user = Users::findOrFail($uuid);
        $bridge = new BridgeContent();
        $credits = $user->credits + $request->get('credits');
        if ($credits < 0) {
            $credits = 0;
        }

        $bridge->contentUpdate('users', [
           'uuid' => $uuid,
           'credits' => $credits
        ]);

        return [
            "total" => $credits
        ];
    }

    /**
     * Can user update catering
     *
     * @param Request $request
     *
     * @return array
     * @throws AuthenticationException
     */
    public function CanUpdate(Request $request)
    {
        $me = Auth::user();
        if (!$me instanceof AuthUser) {
            throw new AuthenticationException();
        }

        /** @var User $user */
        $user = User::find($me->uuid);
        if (!$user->hasRole('super_administrator') && !$user->hasRole('catering_services_team')) {
            return [
                'success' => false
            ];
        }
        return [
            'success' => true
        ];
    }
}
