<?php

use Illuminate\Database\Migrations\Migration;
use Inside\I18n\Repositories\TranslationRepository;
use Inside\I18n\Repositories\LanguageRepository;
use Inside\I18n\Models\Language;
use Inside\I18n\Models\Translation;

class DeleteReservationsEmailsNotificationOverride extends Migration
{
    public function up(): void
    {
        $translationKey = 'notifications.reservation.email.reservation_created_team_notification.content';
        $languageRepository = new LanguageRepository(new Language(), app());
        $repository = new TranslationRepository(new Translation(), app(), $languageRepository);
        if ($repository->get($translationKey, config('app.locale'))) {
            $repository->deleteOverridedTranslationsByKey($translationKey, config('app.locale'));
        }
    }
}
