<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class DeleteOldNotificationsTypes extends Migration
{
    public function up(): void
    {
        // delete old notification types that will be replaced by manual notifications
        NotificationType::where([
            'model' => 'Inside\Content\Models\Contents\Events',
            'action' => 'create',
            'type' => 'global'
        ])->orWhere(fn ($query) => $query->where([
            'model' => 'Inside\Content\Models\Contents\News',
            'condition' => 'is_featured:1|status:1'
        ]))->delete();
    }
}
