<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Layout\Models\LayoutPath;
use Inside\Layout\Models\Layout;

class SeedCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        collect([
            ['title' => 'Room reservations', 'custom_slug' => 'room-reservations', 'redirection_page' => 'RoomReservationPage'],
            ['title' => 'All reservations', 'custom_slug' => 'all-reservations', 'redirection_page' => 'AllReservationsListingPage'],
            ['title' => 'Manage users credits', 'custom_slug' => 'credits', 'redirection_page' => 'UsersCreditsPage'],
        ])->each(fn ($custom) => $bridge->contentInsert(type: 'custom', data: $custom, fromCli: true));

        collect([
            ['type' => 'feedback_forms', 'old' => 'feedback-forms-one-customs', 'new' => 'FeedbackFormsOne'],
            ['type' => 'feedback_forms', 'old' => 'feedback-forms-two-customs', 'new' => 'FeedbackFormsTwo'],
            ['type' => 'register_forms', 'old' => 'register-forms-one-customs', 'new' => 'RegisterFormsOne'],
            ['type' => 'register_forms', 'old' => 'register-forms-two-customs', 'new' => 'RegisterFormsTwo'],
            ['type' => 'register_forms', 'old' => 'register-forms-three-customs', 'new' => 'RegisterFormsThree'],
        ])->each(
            fn ($content) => call_user_func(type_to_class($content['type']).'::query')
                ->where('component', $content['old'])
                ->get()
                ->each(fn ($form) => $bridge->contentUpdate(
                    type: $content['type'],
                    data: ['uuid' => $form->uuid, 'component' => $content['new']]
                ))
        );

        LayoutPath::with('layout')
            ->where('path', 'not like', 'inside_content_forms.%')
            ->get()
            ->pluck('layout')
            ->each(fn (Layout $layout) => $layout->delete());
    }
}
