<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;
use Inside\Content\Models\Contents\News;

class addNewPreferencesNotifications extends Migration
{
    public function up(): void
    {
        NotificationType::query()->where('profile', true)->each(function ($type) {
            $type->profile = false;
            $type->save();
        });

        NotificationType::query()
            ->where(function ($query) {
                $query->where('model', News::class)
                    ->where('event', 'Inside\Content\Events\ContentCreatedEvent')
                    ->where('action', 'create')
                    ->where('condition', 'is_featured:1|status:1');
            })->orWhere(function ($query) {
                $query->where('model', 'Inside\Content\Models\Contents\Comments')
                    ->where('event', 'Inside\Content\Events\ContentCreatedEvent')
                    ->where('action', 'contentCommented')
                    ->where('type', 'global')
                    ->where('condition', 'parent_type:news,events|author:CURRENT_USER');
            })->orWhere(function ($query) {
                $query->where('model', 'Inside\Content\Models\Contents\Comments')
                    ->where('event', 'Inside\Content\Events\CommentCreatedEvent')
                    ->where('action', 'commentCommented');
            })->orWhere(function ($query) {
                $query->where('event', 'Inside\Reaction\Events\ReactionSubscribedEvent')
                    ->where('action', 'follow');
            })->orWhere(function ($query) {
                $query->where('model', 'Inside\Content\Models\Contents\Events')
                    ->where('event', 'Inside\Notify\Events\CustomNotificationEvent')
                    ->where('action', 'start');
            })->each(function ($type) {
                $type->profile = true;
                $type->save();
            });
    }
}
