<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeUsersRelatedContentTypesPermissible extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = ["locations", "users_roles", "users_status"];

        foreach ($contentTypes as $type) {
            $bridge->updateContentTypeOptions($type, [
               'permissible' => true,
               'categorizable' => true
            ]);
        }
    }

    public function down(): void
    {
    }
}
