<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class RemoveContentCommentNotificationFromProfile extends Migration
{
    public function up(): void
    {
        NotificationType::query()->where('action', 'contentCommented')
            ->where('type', 'global')->where('profile', 1)
            ->each(function ($type) {
                $type->profile = 0;
                $type->save();
            });

        NotificationType::query()->where('action', 'report')
            ->where('model', 'Inside\Content\Models\Contents\Comments')
            ->where('profile', 1)->delete();
    }

    public function down(): void
    {
    }
}
