<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CleanRegisterEventsNotifications extends Migration
{
    public function up(): void
    {
        NotificationType::query()->where('via', 'email')
            ->where('model', 'Inside\Content\Models\Contents\Events')
            ->where('event', 'Inside\Notify\Events\CustomNotificationEvent')
            ->where('action', 'system')->delete();

        NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Notify\Events\CustomNotificationEvent',
                'model' => '',
                'action' => 'registerEvent',
                'type' => 'system',
                'condition' => '',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data' => [
                    'title' => "notifications.events.register.title",
                    'description' => "notifications.events.register.description",
                    'mail' => [
                        'subject' => 'notifications.events.register.subject',
                        'text' => 'notifications.events.register.text',
                        'buttonText' => 'notifications.events.register.buttonText'
                    ],
                    'fields' => [
                        ['author' => ['firstname', 'lastname']],
                        'title'
                    ]
                ]
            ]
        );
    }

    public function down(): void
    {
    }
}
