<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Notify\Models\NotificationType;

class AddNotifyFieldToEvents extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $types = ['events', 'groups_events'];
        $notificationTypes = [];

        foreach ($types as $type) {
            $bridge->contentTypeCreateOrUpdateField(
                $type,
                'notify',
                [
                    'name' => 'notify',
                    'searchable' => false,
                    'translatable' => false,
                    'default' => false,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'editable' => false,
                    'weight' => 6,
                    'title' => [
                        'en' => 'Notify users'
                    ],
                    'description' => [
                        'en' => ''
                    ],
                    'widget' => [
                        'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                        'settings' => [
                            'display_label' => true,
                        ],
                        'group' => 'group_advanced_options',
                    ],
                    'type' => BridgeContentType::BOOLEAN_FIELD,
                    'settings' => [
                        'cardinality' => 1,
                    ],
                ],
                6
            );
        }

        NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Notify\Events\CustomNotificationEvent',
                'model' => '',
                'action' => 'eventEdited',
                'type' => 'system',
                // useless condition, just so we don't have to check the code to know what it does exactly
                'condition' => 'notify:1',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data' => [
                    'title' => "notifications.events.edit.registration.title",
                    'description' => "notifications.events.edit.registration.title",
                    'mail' => [
                        'subject' => 'notifications.events.edit.registration.subject',
                        'text' => 'notifications.events.edit.registration.text',
                        'buttonText' => 'notifications.events.edit.registration.buttonText'
                    ],
                    'fields' => [
                        ['author' => ['firstname', 'lastname']],
                        'title'
                    ]
                ]
            ]
        );
    }

    public function down(): void
    {
    }
}
